#ifndef __AST__TYPE_H
#define __AST__TYPE_H

#include <iostream>
#include "translationcontext.h"

class Type
{
    public:
        virtual ~Type() = 0;
        virtual void dump(std::ostream& os, int depth) = 0;
        virtual llvm::Type* translate(TranslationContext* ctx) = 0;

};

class TypeInt32 : public Type
{
    public:
        ~TypeInt32();
        void dump(std::ostream& os, int depth) override;
        llvm::Type* translate(TranslationContext* ctx) override;
};


#endif
