#ifndef __SYMBOLTABLE_H
#define __SYMBOLTABLE_H

#include <vector>
#include <map>
#include <string>

#include <llvm/IR/IRBuilder.h>


namespace llvm { class Value; }
namespace llvm { class Type; }

class SymbolTableEntry
{
    public:
        llvm::Type* type;
        llvm::Value* ref;
        std::string name;
};


typedef std::map < std::string, SymbolTableEntry* > scope;


class SymbolTable {

    private:
        std::vector< scope* > table;

    public:
        SymbolTable();
        ~SymbolTable();
        void push_scope();
        void pop_scope();
        void insert(llvm::Type* type, const std::string& id, llvm::Value* decl);
        SymbolTableEntry* lookup(const std::string& id);

};

#endif
