
#include <iostream>
#include <fstream>

#include "TestParser.h"
#include "TestLexer.h"


int main(int argc, char** argv)
{
    std::ifstream example( argv[1] );
    TestLexer lexer(&example, &std::cout);

    Statement* ast = nullptr;
    yy::TestParser parser(&lexer, &ast);
    if(parser.parse() == 0)
    {
        #define vt100YELLOW "\x1b[33m"
        std::cout << std::endl << vt100YELLOW;
        ast -> dump(std::cout, 0);
    }

    std::cout << std::endl;
    delete ast;
    return 0;
}
