
#include "statement.h"
#include "expression.h"
#include "type.h"

#define indent(depth, txt) for(int i = 0; i < depth; i++) os << "    "; os << txt << std::endl;



Statement::~Statement()
{
}

// ===========================================================

Block::Block(std::vector<Statement*>* statements)
{
    this->statements = statements;
}
Block::~Block()
{
    for(Statement* statement : *statements)
        delete statement;
    delete statements;
}
void Block::dump(std::ostream& os, int depth)
{
    indent(depth, "Block")
    for(Statement* statement : *statements)
        statement->dump(os, depth+1);
}

// ===========================================================

VarDeclaration::VarDeclaration(Type* type, std::string* name, RValue* value)
{
    this->type = type;
    this->name = name;
    this->value = value;
}
VarDeclaration::~VarDeclaration()
{
    delete type;
    delete name;
    delete value;
}
void VarDeclaration::dump(std::ostream& os, int depth)
{
    indent(depth, "VarDeclaration " << *name)
    type->dump(os, depth+1);
    value->dump(os, depth+1);
}

// ===========================================================

Assignment::Assignment(LValue* lvalue, RValue* rvalue)
{
    this->lvalue = lvalue;
    this->rvalue = rvalue;
}
Assignment::~Assignment()
{
    delete lvalue;
    delete rvalue;
}
void Assignment::dump(std::ostream& os, int depth)
{
    indent(depth, "Assignment")
    lvalue->dump(os, depth+1);
    rvalue->dump(os, depth+1);
}

// ===========================================================

Input::Input(LValue* lvalue)
{
    this->lvalue = lvalue;
}
Input::~Input()
{
    delete lvalue;
}
void Input::dump(std::ostream& os, int depth)
{
    indent(depth, "Input")
    lvalue->dump(os, depth+1);
}

// ===========================================================

Output::Output(RValue* rvalue)
{
    this->rvalue = rvalue;
}
Output::~Output()
{
    delete rvalue;
}
void Output::dump(std::ostream& os, int depth)
{
    indent(depth, "Output")
    rvalue->dump(os, depth+1);
}

// ===========================================================

IfThenElse::IfThenElse(BooleanExpression* condition, Statement* thenCase, Statement* elseCase)
{
    this->condition = condition;
    this->thenCase = thenCase;
    this->elseCase = elseCase;
}
IfThenElse::~IfThenElse()
{
    delete condition;
    delete thenCase;
    delete elseCase;
}
void IfThenElse::dump(std::ostream& os, int depth)
{
    indent(depth, "IfThenElse")
    condition->dump(os, depth+1);
    thenCase->dump(os, depth+1);
    elseCase->dump(os, depth+1);
}

// ===========================================================

WhileLoop::WhileLoop(BooleanExpression* condition, Statement* body)
{
    this->condition = condition;
    this->body = body;
}
WhileLoop::~WhileLoop()
{
    delete condition;
    delete body;
}
void WhileLoop::dump(std::ostream& os, int depth)
{
    indent(depth, "WhileLoop")
    condition->dump(os, depth+1);
    body->dump(os, depth+1);
}
