
#include "expression.h"


Expression::~Expression()
{
}


ArithmeticExpressionConstant::ArithmeticExpressionConstant(int value)
{
    this->value = value;
}
void ArithmeticExpressionConstant::dump(std::ostream& os, int depth)
{
    for(int i = 0; i < depth; i++)
        os << "    ";
    os << "ArithmeticExpressionConstant " << value << std::endl;
}


BooleanExpressionNot::BooleanExpressionNot(BooleanExpression* expr)
{
    this->expr = expr;
}
BooleanExpressionNot::~BooleanExpressionNot()
{
    delete expr;
}
void BooleanExpressionNot::dump(std::ostream& os, int depth)
{
    for(int i = 0; i < depth; i++)
        os << "    ";
    os << "BooleanExpressionNot" << std::endl;
    expr->dump(os, depth+1);
}


LValueIdentifier::LValueIdentifier(std::string* identifier)
{
    this->identifier = identifier;
}
LValueIdentifier::~LValueIdentifier()
{
    delete identifier;
}
void LValueIdentifier::dump(std::ostream& os, int depth)
{
    for(int i = 0; i < depth; i++)
        os << "    ";
    os << "LValueIdentifier " << *identifier << std::endl;
}


#define BINOP_DEF(C,B,LT,RT) \
    C :: C(LT l, RT r) \
    : B() \
    { \
        this -> l = l; \
        this -> r = r; \
    } \
    C :: ~C() \
    { \
        delete l; \
        delete r; \
    } \
    void C :: dump(std::ostream& os, int depth) \
    { \
        for(int i = 0; i < depth; i++) \
            os << "    "; \
        os << #C << std::endl; \
        l->dump(os, depth+1); \
        r->dump(os, depth+1); \
    }

#define BOOLEXP_DEF(C) \
    BINOP_DEF(C, BooleanExpression, BooleanExpression*, BooleanExpression*)
BOOLEXP_DEF(BooleanExpressionAnd)
BOOLEXP_DEF(BooleanExpressionOr)

#define RELEXP_DEF(C) \
    BINOP_DEF(C, RelationExpression, ArithmeticExpression*, ArithmeticExpression*)
RELEXP_DEF(RelationExpressionLess)
RELEXP_DEF(RelationExpressionLessEqual)
RELEXP_DEF(RelationExpressionEqual)
RELEXP_DEF(RelationExpressionUnequal)
RELEXP_DEF(RelationExpressionGreaterEqual)
RELEXP_DEF(RelationExpressionGreater)

#define ARITHEXP_DEF(C) \
    BINOP_DEF(C, ArithmeticExpression, ArithmeticExpression*, ArithmeticExpression*)
ARITHEXP_DEF(ArithmeticExpressionPlus)
ARITHEXP_DEF(ArithmeticExpressionMinus)
ARITHEXP_DEF(ArithmeticExpressionMultiply)
ARITHEXP_DEF(ArithmeticExpressionDivide)
ARITHEXP_DEF(ArithmeticExpressionModulus)
